#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Persian carpet 18Mod01.fsh   by   Jarble 
//https://www.shadertoy.com/view/fl3GDB
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//change these constants to get different patterns!
#define c2 0.0

#define c1 vec4(3.0+c2,2.5+c2,1.5,0)
//#define c1 vec4(2.0+c2,1.5+c2,1.4,0)
//#define c1 vec4(1.0,1.5,1.4,0)
//#define c1 vec4(7.0,5.0,1.4,0)
//#define c1 vec4(7.0,9.0,1.4,0)
//#define c1 vec4(5.0,5.5,1.4,0)

//----------------------------------------------------------------------------------------
//  3 out, 1 in...
vec3 hash31(float p)
{
    //from David Hoskin's "Hash without sine"
   vec3 p3 = fract(vec3(p) * vec3(.1031, .1030, .0973));
   p3 += dot(p3, p3.yzx+33.33);
   return fract((p3.xxy+p3.yzz)*p3.zyx); 
}

vec2 triangle_wave(vec2 a,float scale){
    return abs(fract((a+c1.xy)*scale)-.5);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    fragColor = vec4(0.0);
    
    

    
    vec3 col;  
    float t1 = 4.5/8.;

    vec2 uv = (fragCoord)/iResolution.y/t1/2.0;
    uv += vec2(iTime/2.0,iTime/3.0)/t1/8.0;
    if(iMouse.z>.5)
    uv = uv.xy + iMouse.xy / iResolution.xy/t1;
    //vec3 random1 = hash31(floor((iTime)/10.0+uv.x))*10.*.0;
    //vec3 random2 = hash31(1.+floor((iTime)/10.0+uv.x));
    float t2 = floor((iTime/2.+uv.x)/10.0);
    vec3 random1 = (hash31(3.+t2)-.5)/12.;
    vec3 random2 = (hash31(4.+t2)-.5)/12.;
    vec3 random3 = (hash31(3.+t2)-vec3(.5))/1.5;
    //vec3 random4 = (hash31(4.+t2)-vec3(.5))/4.;
    
    float offset = .5;
    float scale2 = 1.5;
    float bend = 1.;
    vec3 col1 = col;
    for(int c=0;c<3;c++){
        float scale = c1.z;
        //float scale1 = 1.0;
        for(int i=0;i<3;i++)
        {
            
            for(int k = 0; k < 3; k++){    
                uv /= -scale2;
                //uv += fract(uv/1.5)/16.; //a more interesting quilt pattern
                //uv += (fract(uv.y/16.)+fract(uv.x/16.))/16.; //a more interesting quilt pattern


                //float scale = scale - col.x/16.;
                //uv /= -scale2+col.x;

                //float bend = 1.+random3[k];
                //bend = abs(fract((uv.x)*2.)-.5)/2.+1.;
                //bend = 1.+1./3.;
                //bend = scale2/1.5;
                
                //bend = abs(fract(((uv.x*bend+uv.y/bend)/scale2))-.5)+1.-col.x;

                //uv *= 1.-col.x;
                
                
                //float offset = offset + float(i);
                vec2 t2 = triangle_wave(uv.yx-offset,scale);
                vec2 t3 = triangle_wave(uv,scale);
                uv.yx = t2/bend+t3*bend;
                //uv += fract(uv.x/(4.))/4.; //a more interesting quilt pattern

                //uv.y *= 1.-col.x;
                //uv.yx = triangle_wave(uv.yx-offset/1.5,scale)*bend-triangle_wave(uv-offset,scale)/bend;

                //bend += 1./(1.+uv.x+uv.y);
                //bend = 1./bend;
                uv += vec2(random1[k],random2[k]);  
                //bend *= -1.;
                //bend -= 1./3.-col.x;
                //bend = 1.+uv.x/2.;

            }
            

            //offset += .5;
            scale /= 1.+(scale2)*col.x/(8.);
            scale2 -= (col.x-1.)/(4.);


            col[c] = abs((uv.x)-(uv.y));
            col1 = abs(col-col1.yzx);
            //random2 = col - random2;
            

        }
	}
    
    fragColor =
        vec4(vec3(col*2.),1.0);
        //vec4(vec3(col1*2.),1.0);
    



         

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

